/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ptmp.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.LTV;
import com.cisco.pt.impl.EncodedBufferFactory;
import com.cisco.pt.impl.LTVFactory;
import com.cisco.pt.ptmp.ConnectionNegotiationProperties;
import com.cisco.pt.ptmp.PacketTracerConnection;
import com.cisco.pt.ptmp.Pipeline;
import com.cisco.pt.ptmp.filter.Filter;
import com.cisco.pt.ptmp.filter.impl.XorEncryptionFilter;
import com.cisco.pt.ptmp.filter.impl.ZlibCompressionFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineImpl
implements Pipeline {
    private static Log logger = LogFactory.getLog(PipelineImpl.class);
    private PacketTracerConnection packetTracerConnection;
    private List<Filter> filters;
    private ByteBuffer outBuffer;

    public PipelineImpl(PacketTracerConnection packetTracerConnection) {
        this.packetTracerConnection = packetTracerConnection;
        this.loadFilters();
        this.outBuffer = ByteBuffer.allocate(1000000);
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public LTV read() throws IOException, InterruptedException {
        ByteBuffer inBuffer = this.packetTracerConnection.getNextMessage();
        byte[] message = new byte[inBuffer.limit()];
        inBuffer.get(message);
        if (this.filters != null && !this.filters.isEmpty()) {
            ReverseListIterator iter = new ReverseListIterator(this.filters);
            while (iter.hasNext()) {
                Filter filter = (Filter)iter.next();
                message = filter.in(message);
            }
        }
        int encoding = this.packetTracerConnection.connectionNegotiationProperties().getEncoding();
        EncodedBuffer encBuffer = EncodedBufferFactory.getInstance(encoding);
        encBuffer.setRawBytes(message);
        LTV ltv = LTVFactory.createLTV(encBuffer);
        if (logger.isInfoEnabled() && ltv != null) {
            logger.info((Object)("Pipeline received message type: [" + ltv.getType() + "]"));
        }
        return ltv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LTV ltv) throws IOException {
        int encoding = this.packetTracerConnection.connectionNegotiationProperties().getEncoding();
        EncodedBuffer encBuffer = EncodedBufferFactory.getInstance(encoding);
        ltv.encodeTypeAndPayload(encBuffer);
        byte[] message = encBuffer.getRawBytes();
        if (this.filters != null && !this.filters.isEmpty()) {
            for (Filter filter : this.filters) {
                message = filter.out(message);
            }
        }
        encBuffer.clear();
        encBuffer.putInt(message.length);
        ByteBuffer byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            this.outBuffer.clear();
            this.outBuffer.put(encBuffer.getRawBytes());
            this.outBuffer.put(message);
            this.outBuffer.flip();
            int written = this.packetTracerConnection.write(this.outBuffer);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Pipeline sent message type: [" + ltv.getType() + "]"));
                logger.info((Object)("Pipeline wrote # of bytes: [" + written + "]"));
            }
        }
    }

    private void loadFilters() {
        this.filters = new ArrayList<Filter>();
        ConnectionNegotiationProperties connectionNegotiationProperties = this.packetTracerConnection.connectionNegotiationProperties();
        if (connectionNegotiationProperties.getCompression() == 2) {
            this.filters.add(new ZlibCompressionFilter());
        }
        if (connectionNegotiationProperties.getEncryption() == 2) {
            XorEncryptionFilter xorFilter = new XorEncryptionFilter(connectionNegotiationProperties);
            this.filters.add(xorFilter);
        }
    }
}

